
;LCD Port
rs		reg	p3.7
rw		reg	p3.6
en		reg 	p3.4
LCD_data_bus	reg	p2

;Key Port
key_play		reg	p0.7	;   
key_next		reg	p0.6	; eject		  stop
key_previous	reg	p0.5	;		
key_pause		reg	p0.4	; 	previous	  play	next
key_stop		reg	p0.3	;  
key_eject		reg	p0.2	;
key_mode		reg	p0.1	; modee		  pause

flag_pause	reg	20h.0	;"1"Ȱ
flag_stop		reg	20h.1	;"1"
flag_eject		reg	20h.2	;"1"}Ҥ
flag_ready		reg	20h.3	;"1"ǳƦni
flag_play		reg	20h.4	;"1"
flag_return	reg	f0	;"1"Ƽ
flag_return_1	reg	21h.1	;;"1"ƼP@

playing_track	equ 	08h
end_track		equ	09h
length_M		equ	0ah
length_S		equ	0bh
IR_DATA	equ	0ch
DR_DATA	equ	0dh
bcd_track		equ	0eh	;bcd X
bcd_end		equ	0fh	;bcd X
track_num_1	equ	10h
track_num_2	equ	11h
end_track_1	equ	12h
end_track_2	equ	13h
bcd_m		equ	14h
bcd_s		equ	15h
bcd_m_1		equ	16h
bcd_m_2		equ	17h
bcd_s_1		equ	18h
bcd_s_2		equ	19h
total_m		equ	1ah
total_s		equ	1bh

	org	00h			;
	jmp	start			;


;=====================================
;===========   CƵ{   ==========
;=====================================
get_data:					;
	acall	uart_wait			;
	mov	end_track,a		;
	acall	uart_wait			;
	mov	length_M,a		;
	acall	uart_wait			;
	mov	length_S,a			;
	acall	uart_wait			;
	mov	total_m,a			;
	jnb	ri,$			;	
	clr	ri			;
	mov	a,sbuf			;
	mov	total_s,a			;
	ret				;
uart_wait:					;
	jnb	ri,uart_wait		;	
	clr	ri			;
	mov	a,sbuf			;
	ret

;	mov	r4,#1			;
;	mov 	r7,#1 			;
;	acall 	delay_5ms 		;
;=====================================
;============    Ƶ{ 1  ============
;=====================================
next_key:					;
	jnb     	key_next,$ 		;
	jb	flag_eject,scan_key_loop	;
	mov	a,playing_track		;
	inc	a			;
	inc	end_track			;
	cjne	a,end_track,next_2		;
	mov	playing_track,#0		;
next_2:					;
	dec	end_track			;
	inc	playing_track		;
	mov	dptr,#string_next		;
	acall	print_line			;	
	acall	print_track		;
	acall	return_1			;
	jnb	key_pause	,scan_key_loop	;
	jmp	start_loop_1		;
previous_key:				;
	jnb     	key_previous,$ 		;
	jb	flag_eject,scan_key_loop	;
	djnz	playing_track,previous_2	;	
	mov	playing_track,end_track	;
previous_2:				;
	mov	dptr,#string_previous	;
	acall	print_line			;
	acall	print_track		;
	acall	return_1			;
	jnb	key_pause	,scan_key_loop	;
	jmp	start_loop_1		;
return_one:
	setb	flag_return_1		;
	mov	a,#0			;	
	mov	b,#0ch			;
	acall	GotoXY			;
	mov	dptr,#string_return_1		;	
	acall	PrintString			;
	ret				;
	
;=====================================
;===========   䱽yƵ{   ===========
;=====================================
eject_key_1:				;
	jmp	eject_key			;
scan_key:					;
	jnb	key_play,play_key		;
	jnb	key_next,next_key		;
	jnb	key_previous,previous_key	;
	jnb	key_pause	,pause_key	;
	jnb	key_stop,stop_key		;
	jnb	key_eject,eject_key_1	;
	jnb	key_mode,mode_key	;
	jnb	key_play,play_key		;
	ret				;

scan_key_loop:				;
	jnb	key_play,play_key		;
	jnb	key_next,next_key		;	
	jnb	key_previous,previous_key	;
	jnb	key_pause	,pause_key	;
	jnb	key_stop,stop_key		;
	jnb	key_eject,eject_key_1	;	
	jnb	key_mode,mode_key	;
	jmp	scan_key_loop		;
;=====================================
;============    Ƶ{ 2  ============
;=====================================
return_1: 					;
	jb	flag_return_1,return_one
	jnb	flag_return,non_return	;
	mov	a,#0			;
	mov	b,#0ch			;
	acall	GotoXY			;	
	mov	dptr,#string_return		;
	acall	PrintString			;
	ret				;
mode_key:				;
	jnb     	key_mode,$ 		;
	jb	flag_pause,scan_key_loop	;
	jb	flag_stop,scan_key_loop	;
	jb	flag_eject,scan_key_loop	;
	jbc	flag_return,return_one	;
	jbc	flag_return_1,non_return	;
	setb	flag_return		;
	acall	return_1			;
	ret				;

non_return:				;
	mov	a,#0			;	
	mov	b,#0ch			;
	acall	GotoXY			;
	mov	dptr,#string_no_return	;	
	acall	PrintString			;
	ret				;
play_key:					;
	jnb     	key_play,$ 		;
	jb	flag_stop,play_key_jump	;
	jb	flag_play,scan_key		;
	jb	flag_pause,resume_cmd	;	
	jb	flag_eject,close_cmd		;
play_key_jump:				;
	jmp	start_loop_1		;
pause_key:				;
	jnb     	key_pause,$ 		;	
	jb	flag_play,pause_cmd		;
	jb	flag_pause,resume_cmd	;
	jb	flag_stop,scan_key_loop	;
	jb	flag_eject,scan_key_loop	;
stop_key:					;
	jnb     	key_stop,$ 		;
	jb	flag_play,stop_cmd		;
	jb	flag_pause,stop_cmd	;
	jb	flag_stop,scan_key_loop	;
	jb	flag_eject,scan_key_loop	;

eject_key:					;
	jnb     	key_eject,$ 		;
	jb	flag_play,eject_cmd_jump	;
	jb	flag_pause,eject_cmd_jump	;
	jb	flag_stop,eject_cmd_jump	;
	jb	flag_eject,close_cmd
eject_cmd_jump:				;
	jmp	eject_cmd			;
;=====================================
;=============    {   =============
;=====================================
;oeO & ܺX
;

play_cmd:					;
	mov	a,playing_track		;
	orl	a,#80H			;
	mov	sbuf,a			;
	acall	tram_wait			;
	mov	a,playing_track		;
	acall	get_data			;
	mov	sbuf,#00000001b		;
	acall	tram_wait			;
	mov	dptr,#string_play		;
	acall	print_line			;
	acall	print_track		;
	acall	return_1			;
	mov	20h,#00011000b		;
	ret				;

close_cmd:				;
	mov	sbuf,#00100000b		;
	acall	tram_wait			;
	clr	flag_eject			;
	mov	sp,#4fh			;
	jmp	start_loop			;
resume_cmd:				;
	mov	sbuf,#00000100b		;
	acall	tram_wait			;
	mov	a,#1			;
	mov	b,#0bh			;
	acall	GotoXY			;
	mov	dptr,#string_resume		;
	acall	PrintString			;
	mov	20h,#00011000b		;
	ret				;
pause_cmd:				;
	mov	sbuf,#00000010b		;
	acall	tram_wait			;
	mov	a,#1			;
	mov	b,#0bh			;
	acall	GotoXY			;
	mov	dptr,#string_pause		;
	acall	PrintString			;
	mov	20h,#00001001b		;
	jmp	scan_key_loop		;
stop_cmd:				;
	mov	sbuf,#00001000b		;
	acall	tram_wait			;
	mov	dptr,#string_stop		;
	acall	print_line			;
	mov	a,#1h			;
	mov	b,#0dh			;
	acall	GotoXY			;
	acall	print_end_track		;
	mov	a,#0			;
	mov	b,#0bh			;
	acall	GotoXY			;
	acall	print_total_time		;
	mov	20h,#00001010b		;
	mov	playing_track,#1		;
	jmp	scan_key_loop		;
eject_cmd:				;	
	mov	sbuf,#00010000b		;
	acall	tram_wait			;
	mov	dptr,#string_eject		;
	acall	print_line			;
	mov	20h,#00000100b		;
	mov	playing_track,#1		;
	jmp	scan_key_loop		;


;=====================================
;==========   ǰeݰƵ{   ============
;=====================================

tram_wait:					;
	jbc	ti,tram_ok			;
	jmp	tram_wait			;
tram_ok:					;
	ret				;

;=====================================
;========   CǿlưƵ{   ========
;=====================================
Initial_UART:				;
	mov	tmod,#20h		;
	mov	th1,#0fdh			;ǿtv 9600 bps
	setb	tr1			;P timer 1
	mov	scon,#50h			;]wCǿ mode 1
	setb	ea			;Pत_
	setb	es			;PC
	ret				;


;=====================================
;========   LCD ҲժlưƵ{   ========
;=====================================
Initial_LCD:	;
	mov	r4,#1			;
	mov	r7,#4			;
	acall	delay_5ms		;
	mov	IR_DATA,#00111000b 	;
	acall 	Write_IR		     	;
	mov	r4,#1			;
	mov 	r7,#2		    	;
	acall 	delay_5ms 		;
	mov 	IR_DATA,#00111000b 	;
	acall 	Write_IR 			;
	mov	r4,#1			;
	mov 	r7,#1 			;
	acall 	delay_5ms 		;
	mov 	IR_DATA,#00111000b	;
	acall 	Write_IR 			;
	mov 	IR_DATA,#00001000b 	;
	acall 	Write_IR 			;
	mov 	IR_DATA,#00000001b 	;
	acall 	Write_IR 			;
	mov 	IR_DATA , #00000110b 	;
	acall 	Write_IR 			;
	mov 	IR_DATA,#00001100b 	;
	acall 	Write_IR 			;
	ret 				;


;=====================================
;========= ˬdLX BF Ƶ{ ========
;=====================================
CheckBF:	;
	Push 	a			;
wait:					;
	Clr	rs			;rs=0
	Setb	rw			;r/w=0
	Setb 	en 			;en=1
	Mov	a,LCD_data_bus		;
	Clr	en 			;en=0
	Jb	acc.7,wait			;P_BFX(ACC.7)O_0,Y
					;BF=lhLCDb~򵥫ݪ
					;BF=0,CPU~igƵLCD
	mov 	r7,#0			;
	djnz 	r7,$			;DELAY
	pop 	a			;BFwg0,iH}Ƶ{
	ret				;

;================================================
;============  gƨIRȦsƵ{   ==============
;================================================
Write_IR:					;
	acall	CheckBF			;ˬdBFX
	clr	rs			;RS=0
	clr	rw			;R/W
	setb	en			;E=1
	nop				;
	mov	LCD_data_bus,IR_DATA 	;NOXΦ}eLEDҲ
	nop				;
	clr	en			;E=0
	mov	r7,#0			;
	djnz	r7,$			;Delay
	ret				;

;===============================================
;============  gƨDRȦsƵ{   ============
;===============================================

Write_DR:				;
	acall	CheckBF			;ˬdBFX
	setb 	rs			;RS=1
	clr	rw			;R/W=0
	setb 	en 			;E=l
	nop				;
	mov 	LCD_data_bus,DR_DATA	;NưeLCDҲ
	nop				;
	clr 	en 			;E=0
	mov	r7,#0			;
	djnz 	r7,$			;Delay
	ret

;==============================================
;============   ܸƨ(a)r(b)m   ===========
;==============================================
GotoXY:	;
	push 	a			;
	anl	b,#00011111b		;
	cjne 	a,#0,Line1			;
	mov 	a,b			;
	add 	a ,#80h			;]wRAMmO00h+(b)}l
	mov 	IR_DATA,a		;]NOѲĤ@檺bӦr}l
	acall	Write_IR			;ܦr
	pop 	a			;
	ret				;
Line1:					;
	mov 	a,b			;
	add 	a,#11000000b		;]wRAMmO40h+(b)}l
	mov	IR_DATA,a 		;]NOѲĤG檺bӦr}l
	acall	Write_IR 			;ܦr
	pop 	a			;
	ret				;

;==================================================
;=================   g@Ӧr LCD   ============
;==================================================
PrintString:				;
	push 	a			;
PrintLoop:				;
	clr	a			;
	movc 	a,@a+dptr		;Ndptr_rv@eLCD
	cjne 	a,#'$',next_string 		;ܹJ쵲Ÿ"$"~
	jmp 	EndPrint			;
next_string:					;
	mov 	DR_DATA,a 		;
	acall	Write_DR			;
	inc 	dptr			;
	jmp 	PrintLoop			;
EndPrint:					;
	pop 	a			;
	inc 	dptr			;
	ret				;


;========================================
;================   LCDr  ===========
;========================================

print_line:	;
	mov	a,#0h			;
	mov	b,#0h			;
print_line2:				;
	acall	GotoXY			;
	acall	PrintString			;
	inc	a			;
	cjne	a,#2,print_line2		;
	ret
;========================================
;================   LCD r   ==============
;========================================
string_start:	db	'  Read CD ...   $'	;
		db	'Please Wait...^^$'	;

string_stop:	db	'Total Time   :  $'	;
		db	' Total Track    $'	;

string_play:	db	'Track   /       $'	;
		db	'Time   :        $'	;

string_next:	db	'Track   /      $'	;
		db	'   Next Track   $'	;

string_previous:	db	'Track   /      $'	;
		db	' Previous Track $'	;

string_eject:	db	'CD-ROM is open !$';
		db	'Please Wait...^^$'	;

string_pause:	db	'Pause$'		;

string_resume:	db	'     $'		;

string_return	db	'R-A $'		;

string_return_1	db	'R-1 $'		;

string_no_return	db	'    $'		;


;========================================
;=========   track.timeনasciiƵ{   ========
;========================================
print_track:				;
	mov	a,#0			;
	mov	b,#6			;
	acall	GotoXY			;
	mov	a,playing_track		;
	acall	hex_2_bcd		;
	mov	bcd_track,a		;
	acall	ascii_code		;
	mov	track_num_1,b		;
	mov	track_num_2,a		;
	mov	DR_DATA,track_num_2	;
	acall	Write_DR			;
	mov	DR_DATA,track_num_1	;
	acall	Write_DR			;
	mov	DR_DATA,#2fh		;
	acall	Write_DR			;
print_end_track:				;
	mov	a,end_track		;
	acall	hex_2_bcd		;
	mov	bcd_end,a			;
	acall	ascii_code		;
	mov	end_track_1,b		;
	mov	end_track_2,a		;
	mov	DR_DATA,end_track_2	;
	acall	Write_DR			;
	mov	DR_DATA,end_track_1	;
	acall	Write_DR			;
	ret				;

print_total_time:				;
	mov	a,total_m			;
	acall	hex_2_bcd		;
	mov	bcd_m,a			;
	acall	ascii_code		;
	mov	bcd_m_1,b		;
	mov	bcd_m_2,a		;
	mov	DR_DATA,bcd_m_2	;
	acall	Write_DR			;
	mov	DR_DATA,bcd_m_1	;
	acall	Write_DR			;
	mov	DR_DATA,#3ah		;
	acall	Write_DR			;
	mov	a,total_s			;
	acall	hex_2_bcd		;
	mov	bcd_s,a			;
	acall	ascii_code		;
	mov	bcd_s_1,b		;
	mov	bcd_s_2,a			;
	mov	DR_DATA,bcd_s_2		;
	acall	Write_DR			;
	mov	DR_DATA,bcd_s_1		;
	acall	Write_DR			;
	ret				;
print_time:					;
	mov	a,length_M		;
	acall	hex_2_bcd		;
	mov	bcd_m,a			;
	acall	ascii_code		;
	mov	bcd_m_1,b		;
	mov	bcd_m_2,a		;
	mov	DR_DATA,bcd_m_2	;
	acall	Write_DR			;
	mov	DR_DATA,bcd_m_1	;
	acall	Write_DR			;
	mov	DR_DATA,#3ah		;
	acall	Write_DR			;
	mov	a,length_S			;
	acall	hex_2_bcd		;
	mov	bcd_s,a			;
	acall	ascii_code		;
	mov	bcd_s_1,b		;
	mov	bcd_s_2,a			;
	mov	DR_DATA,bcd_s_2		;
	acall	Write_DR			;
	mov	DR_DATA,bcd_s_1		;
	acall	Write_DR			;
	ret				;

ascii_code:				;
	mov	r0,a			;
	anl	a,#0fh			;
	orl	a,#30h			;
	mov	b,a			;

	mov	a,r0			;
	swap	a			;
	anl	a,#0fh			;
	orl	a,#30h			;
	ret				;

hex_2_bcd:				;
	mov	b,a			;
	anl	a,#0fh			;
	da	a			;
	xch	a,b			;
	swap	a			;
	anl	a,#0fh			;
	cjne	a,#0h,bcd_2_bcd_l		;
	xch	a,b			;
	jmp	bcd_2_bcd_end		;
bcd_2_bcd_l:				;
	xch	a,b			;
bcd_2_bcd_2:				;
	add	a,#16h			;
	da	a			;
	djnz	b,bcd_2_bcd_2		;
bcd_2_bcd_end:				;
	ret				;

;========================================
;================   Ƶ{   ============
;========================================
delay_1s:					; r4 * 1s
	mov	r7,#0d5h			;
delay_5ms:				; r7 * 5ms
	mov   	r6,#0afh			;
delay_loop:				;
	acall	scan_key			;
	nop				;
	nop				;
	nop				;
	nop				;
	nop				;
	djnz  	r6,delay_loop		;
	djnz  	r7,delay_5ms		;
	djnz  	r4,delay_1s		;
	ret				;

;=====================================
;==============    D{    ==============
;=====================================

start:					;
	mov	sp,#4fh			;
	acall	Initial_UART		;
	acall	Initial_LCD		;
	clr	flag_return		;
	clr	flag_return_1		;

start_loop:				;
	mov	20h,#01000010b		;
	mov	dptr,#string_start		;
	acall	print_line			;
	acall	get_data			;
	setb	flag_ready			;
	mov	dptr,#string_stop		;
	acall	print_line			;
	mov	a,#1h			;
	mov	b,#0dh			;
	acall	GotoXY			;
	acall	print_end_track		;
	mov	a,#0h			;
	mov	b,#0bh			;
	acall	GotoXY			;
	acall	print_total_time		;
	mov	playing_track,#1		;	
	mov	r4,#5			;
	acall	delay_1s			;
start_loop_1:				;
	acall	play_cmd			;
	mov	sp,#4fh			;
count_down:				;
	mov	a,#1			;
	mov	b,#5			;
	acall	GotoXY			;
	acall	print_time			;
	mov	r4,#1			;
	acall	delay_1s			;
	dec	length_S			;
	mov	a,length_S			;
	cjne	a,#-1,count_down		;
	mov	length_S,#59		;
	dec	length_M			;
	mov	a,length_M		;
	cjne	a,#-1,count_down		;
	mov	a,playing_track		;
	jb	flag_return_1,start_loop_1	;
	cjne	a,end_track,next_track	;
	jb	flag_return,next_track_1	;
	jmp	stop_cmd			;
next_track:				;
	inc	playing_track		;
	jmp	start_loop_1		;
next_track_1:				;
	mov	playing_track,#1		;
	jmp	start_loop_1		;


	end				;